﻿psiType = SDTA;

//menu定义
var MENU_PROG_DESC_BROAD = 2;
var MENU_PROG_DESC_VOD = 6;
var BROADCAST = 0;
var VOD = 1;
var sdtaType;

var menuIdArray = ["modifyTable", "addProgram", "programDescription", "", "", "descriptor", "programMenu"];
var MENU_NUM = 7;

var objIdArray = ["serviceId", "serviceName", "providerName", "charEncode", "serviceType", "customType", "runStatus", "caMode", "eitScheduleFlag", "eitFollowFlag"];
var ROW_NUM = 10;
var customFlag = false;

var vodObjIdArray = ["serviceId", "runStatus", "caMode", "eitScheduleFlag", "eitFollowFlag"];
var VOD_ROW_NUM = 5;

function modifyTable()
{
	actionType = SET;
	operation = OPER_TABLE;
	displayParam();
}

function addProgram()
{
	actionType = ADD;
	sdtaType = VOD;
	operation = OPER_PROG;	
	editProgram();
}

function editProgram()
{
	$("#table").css("display", "none");
	$("#program").css("display", "");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Service Info");
	}
	else
	{
		$("#editHeader").html("节目信息");
	}
	$("#serviceNameTr").css("display", "none");
	$("#providerNameTr").css("display", "none");
	$("#charEncodeTr").css("display", "none");
	$("#serviceTypeTr").css("display", "none");
	$("#customTypeTr").css("display", "none");
	$("#editInfo").modal();
}
function modifyProgram(type)
{
	sdtaType = type;
	actionType = SET;
	operation = OPER_PROG;
	displayParam();
}

function displayTable()
{
	if(operation == OPER_TABLE)
	{
		$("#table").css("display", "");
		$("#program").css("display", "none");
		if(language == ENGLISH)
		{
			$("#editHeader").html("Table Info");
		}
		else
		{
			$("#editHeader").html("表信息");
		}
	}
	else if(operation == OPER_PROG)
	{
		$("#table").css("display", "none");
		$("#program").css("display", "");
		if(language == ENGLISH)
		{
			$("#editHeader").html("Service Info");
		}
		else
		{
			$("#editHeader").html("节目信息");
		}
	}
	$("#editInfo").modal();
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + psiType + "&cmd=" + GET + "&language=" + language + "&id=" + id + "&operation=" + operation + "&index=" + nodeIndex + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(operation == OPER_TABLE)
				{
					$("#streamId").val(data[0]);
					$("#networkId").val(data[1]);
					$("#versionNumber").val(data[2]);
				}
				else if(operation == OPER_PROG)
				{
					if(sdtaType == BROADCAST)
					{
						for(var i = 0; i < ROW_NUM; i++)
						{
							$("#" + objIdArray[i]).val(data[i]);
						}
						if(parseInt($("#serviceType").val(), 10) == CUSTOM)
						{
							$("#customTypeTr").css("display", "");
							customFlag = true;
						}
						else
						{
							$("#customTypeTr").css("display", "none");
							customFlag = false;
						}
					}
					else
					{
						$("#serviceNameTr").css("display", "none");
						$("#providerNameTr").css("display", "none");
						$("#charEncodeTr").css("display", "none");
						$("#serviceTypeTr").css("display", "none");
						$("#customTypeTr").css("display", "none");
						for(var i = 0; i < ROW_NUM; i++)
						{
							$("#" + vodObjIdArray[i]).val(data[i]);
						}
					}
				}
				displayTable();
			}			
		}
	}
	xmlHttp.send(null);	
}

function editPageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&id=" + id + "&operation=" + operation + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(actionType == ADD)
				{
					if(language == ENGLISH)
					{
						alert("Add Successfully!");
					}
					else
					{
						alert("添加成功！");
					}
					self.location.reload(true);
				}
				else if(actionType == SET)
				{
					if(language == ENGLISH)
					{
						alert("Set Successfully!");
					}
					else
					{
						alert("设置成功！");
					}
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			self.location.reload(true);
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	if(operation == OPER_TABLE)
	{
		data = $("#streamId").val() + FIRST_DELIMITER + $("#networkId").val() + FIRST_DELIMITER + $("#versionNumber").val();
	}
	else if(operation == OPER_PROG)
	{
		if(actionType == ADD)
		{
			for( var i = 0; i < VOD_ROW_NUM; i++)
			{
				if(i == 0)
				{
					data = $("#" + vodObjIdArray[i]).val();
				}
				else
				{
					data += FIRST_DELIMITER + $("#" + vodObjIdArray[i]).val();
				}
			}
		}
		else
		{
			if(sdtaType == BROADCAST)
			{
				for( var i = 0; i < ROW_NUM; i++)
				{
					if(i == 0)
					{
						data = nodeIndex + FIRST_DELIMITER + $("#" + objIdArray[i]).val();
					}
					else
					{
						data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
					}
				}
			}
			else
			{
				for( var i = 0; i < VOD_ROW_NUM; i++)
				{
					if(i == 0)
					{
						data = nodeIndex + FIRST_DELIMITER + $("#" + vodObjIdArray[i]).val();
					}
					else
					{
						data += FIRST_DELIMITER + $("#" + vodObjIdArray[i]).val();
					}
				}
			}
		}
	}
	return data;
}

function paramCheck()
{
	var returnFlag;
	var char;
	
	if(operation == OPER_TABLE)
	{
		returnFlag = ValidateParam($("#streamId"), "INT_DEC", 0, 65535, "<Transport Stream ID>", "<传送流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#networkId"), "INT_DEC", 0, 65535, "<Network ID>", "<网络ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#versionNumber"), "INT_DEC", 0, 31, "<Version Number>", "<版本号>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(operation == OPER_PROG)
	{
		returnFlag = ValidateParam($("#serviceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(sdtaType == BROADCAST)
		{
			returnFlag = ValidateParam($("#serviceName"), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#serviceName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#providerName"), "LENGTH", 0, 31, "<Service Provider>", "<节目提供商>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#providerName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#customType"), "INT_DEC", 17, 255, "<Custom Type>", "<自定义类型>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	return true;	
}

function deleteProgram()
{	
	operation = OPER_PROG;
	var confirmPrompt;	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the service?";
	}
	else
	{
		confirmPrompt = "确定要删除当前节目吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		deleteApply();
	}	
}

function changeServiceType(obj)
{
	var height;
	if(parseInt(obj.val(), 10) == CUSTOM)
	{
		$("#customTypeTr").css("display", "");
		if(customFlag == false)
		{
			$("#simplemodal-container").css("height", function(index, value)
				{
					height = $(this).height();
					return ((height + ROW_HEIGHT) + "px");
				});
			customFlag = true;
		}
	}
	else
	{
		$("#customTypeTr").css("display", "none");
		if(customFlag == true)
		{
			$("#simplemodal-container").css("height", function(index, value)
				{
					height = $(this).height();
					return ((height - ROW_HEIGHT) + "px");
				});
			customFlag = false;
		}
	}
}